<?php

/**
 * BaseJobVacancy
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $jobTitleCode
 * @property integer $hiringManagerId
 * @property string $name
 * @property text $description
 * @property integer $noOfPositions
 * @property integer $status
 * @property boolean $publishedInFeed
 * @property datetime $definedTime
 * @property datetime $updatedTime
 * @property JobTitle $JobTitle
 * @property Employee $Employee
 * @property Doctrine_Collection $JobCandidateVacancy
 * @property Doctrine_Collection $JobVacancyAttachment
 * @property Doctrine_Collection $CandidateHistory
 * 
 * @method integer             getId()                   Returns the current record's "id" value
 * @method integer             getJobTitleCode()         Returns the current record's "jobTitleCode" value
 * @method integer             getHiringManagerId()      Returns the current record's "hiringManagerId" value
 * @method string              getName()                 Returns the current record's "name" value
 * @method text                getDescription()          Returns the current record's "description" value
 * @method integer             getNoOfPositions()        Returns the current record's "noOfPositions" value
 * @method integer             getStatus()               Returns the current record's "status" value
 * @method boolean             getPublishedInFeed()      Returns the current record's "publishedInFeed" value
 * @method datetime            getDefinedTime()          Returns the current record's "definedTime" value
 * @method datetime            getUpdatedTime()          Returns the current record's "updatedTime" value
 * @method JobTitle            getJobTitle()             Returns the current record's "JobTitle" value
 * @method Employee            getEmployee()             Returns the current record's "Employee" value
 * @method Doctrine_Collection getJobCandidateVacancy()  Returns the current record's "JobCandidateVacancy" collection
 * @method Doctrine_Collection getJobVacancyAttachment() Returns the current record's "JobVacancyAttachment" collection
 * @method Doctrine_Collection getCandidateHistory()     Returns the current record's "CandidateHistory" collection
 * @method JobVacancy          setId()                   Sets the current record's "id" value
 * @method JobVacancy          setJobTitleCode()         Sets the current record's "jobTitleCode" value
 * @method JobVacancy          setHiringManagerId()      Sets the current record's "hiringManagerId" value
 * @method JobVacancy          setName()                 Sets the current record's "name" value
 * @method JobVacancy          setDescription()          Sets the current record's "description" value
 * @method JobVacancy          setNoOfPositions()        Sets the current record's "noOfPositions" value
 * @method JobVacancy          setStatus()               Sets the current record's "status" value
 * @method JobVacancy          setPublishedInFeed()      Sets the current record's "publishedInFeed" value
 * @method JobVacancy          setDefinedTime()          Sets the current record's "definedTime" value
 * @method JobVacancy          setUpdatedTime()          Sets the current record's "updatedTime" value
 * @method JobVacancy          setJobTitle()             Sets the current record's "JobTitle" value
 * @method JobVacancy          setEmployee()             Sets the current record's "Employee" value
 * @method JobVacancy          setJobCandidateVacancy()  Sets the current record's "JobCandidateVacancy" collection
 * @method JobVacancy          setJobVacancyAttachment() Sets the current record's "JobVacancyAttachment" collection
 * @method JobVacancy          setCandidateHistory()     Sets the current record's "CandidateHistory" collection
 * 
 * @package    orangehrm
 * @subpackage model\recruitment\base
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseJobVacancy extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_job_vacancy');
        $this->hasColumn('id', 'integer', 13, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 13,
             ));
        $this->hasColumn('job_title_code as jobTitleCode', 'integer', 13, array(
             'type' => 'integer',
             'length' => 13,
             ));
        $this->hasColumn('hiring_manager_id as hiringManagerId', 'integer', 13, array(
             'type' => 'integer',
             'length' => 13,
             ));
        $this->hasColumn('name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('description', 'text', null, array(
             'type' => 'text',
             ));
        $this->hasColumn('no_of_positions as noOfPositions', 'integer', 13, array(
             'type' => 'integer',
             'length' => 13,
             ));
        $this->hasColumn('status', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('published_in_feed as publishedInFeed', 'boolean', null, array(
             'type' => 'boolean',
             ));
        $this->hasColumn('defined_time as definedTime', 'datetime', null, array(
             'type' => 'datetime',
             ));
        $this->hasColumn('updated_time as updatedTime', 'datetime', null, array(
             'type' => 'datetime',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('JobTitle', array(
             'local' => 'jobTitleCode',
             'foreign' => 'id'));

        $this->hasOne('Employee', array(
             'local' => 'hiringManagerId',
             'foreign' => 'empNumber'));

        $this->hasMany('JobCandidateVacancy', array(
             'local' => 'id',
             'foreign' => 'vacancyId'));

        $this->hasMany('JobVacancyAttachment', array(
             'local' => 'id',
             'foreign' => 'id'));

        $this->hasMany('CandidateHistory', array(
             'local' => 'id',
             'foreign' => 'vacancyId'));
    }
}